/*
 * Decompiled with CFR 0.152.
 */
package framework.config;

import java.net.URI;
import java.util.Arrays;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="sys.storage.http")
public class FileStorageHttpConfig
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(FileStorageHttpConfig.class);
    private String name;
    private String address;
    private String username;
    private String password;
    private String authorization;
    private String[] compressPathStarts;
    private String[] managers;
    private Integer connectTimeout = 6000;
    private Integer readTimeout = 30000;

    public void setAddress(String address) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return;
        }
        if (!address.endsWith("/")) {
            address = address.endsWith("\\") ? address.substring(0, address.length() - 1) + "/" : address + "/";
        }
        this.address = address;
    }

    public String url(String path) {
        if (path.charAt(0) == '/') {
            return this.address + path.substring(1);
        }
        return this.address + path;
    }

    public URI uri(String path) {
        return URI.create(this.url(path));
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.getAuthorization()) && StringUtils.isNotBlank((CharSequence)this.getUsername()) && StringUtils.isNotBlank((CharSequence)this.getPassword())) {
            this.authorization = "Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public String[] getCompressPathStarts() {
        return this.compressPathStarts;
    }

    public String[] getManagers() {
        return this.managers;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public void setCompressPathStarts(String[] compressPathStarts) {
        this.compressPathStarts = compressPathStarts;
    }

    public void setManagers(String[] managers) {
        this.managers = managers;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileStorageHttpConfig)) {
            return false;
        }
        FileStorageHttpConfig other = (FileStorageHttpConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$connectTimeout = this.getConnectTimeout();
        Integer other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Integer this$readTimeout = this.getReadTimeout();
        Integer other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$authorization = this.getAuthorization();
        String other$authorization = other.getAuthorization();
        if (this$authorization == null ? other$authorization != null : !this$authorization.equals(other$authorization)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCompressPathStarts(), other.getCompressPathStarts())) {
            return false;
        }
        return Arrays.deepEquals(this.getManagers(), other.getManagers());
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileStorageHttpConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Integer $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $authorization = this.getAuthorization();
        result = result * 59 + ($authorization == null ? 43 : $authorization.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCompressPathStarts());
        result = result * 59 + Arrays.deepHashCode(this.getManagers());
        return result;
    }

    public String toString() {
        return "FileStorageHttpConfig(name=" + this.getName() + ", address=" + this.getAddress() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", authorization=" + this.getAuthorization() + ", compressPathStarts=" + Arrays.deepToString(this.getCompressPathStarts()) + ", managers=" + Arrays.deepToString(this.getManagers()) + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ")";
    }
}

