/*
 * Decompiled with CFR 0.152.
 */
package framework.config;

import framework.config.FileConfig;
import framework.config.FileStorageHttpConfig;
import framework.config.S3Config;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="file.manager")
public class FileManagerConfig {
    private static final Logger log = LoggerFactory.getLogger(FileManagerConfig.class);
    private Boolean enable = false;
    private String defaultName;
    private String[] compressPathStarts;
    private FileConfig[] files;
    private S3Config[] s3s;
    private FileStorageHttpConfig[] https;

    public Boolean getEnable() {
        return this.enable;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public String[] getCompressPathStarts() {
        return this.compressPathStarts;
    }

    public FileConfig[] getFiles() {
        return this.files;
    }

    public S3Config[] getS3s() {
        return this.s3s;
    }

    public FileStorageHttpConfig[] getHttps() {
        return this.https;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setDefaultName(String defaultName) {
        this.defaultName = defaultName;
    }

    public void setCompressPathStarts(String[] compressPathStarts) {
        this.compressPathStarts = compressPathStarts;
    }

    public void setFiles(FileConfig[] files) {
        this.files = files;
    }

    public void setS3s(S3Config[] s3s) {
        this.s3s = s3s;
    }

    public void setHttps(FileStorageHttpConfig[] https) {
        this.https = https;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileManagerConfig)) {
            return false;
        }
        FileManagerConfig other = (FileManagerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enable = this.getEnable();
        Boolean other$enable = other.getEnable();
        if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
            return false;
        }
        String this$defaultName = this.getDefaultName();
        String other$defaultName = other.getDefaultName();
        if (this$defaultName == null ? other$defaultName != null : !this$defaultName.equals(other$defaultName)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCompressPathStarts(), other.getCompressPathStarts())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getFiles(), other.getFiles())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getS3s(), other.getS3s())) {
            return false;
        }
        return Arrays.deepEquals(this.getHttps(), other.getHttps());
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileManagerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        String $defaultName = this.getDefaultName();
        result = result * 59 + ($defaultName == null ? 43 : $defaultName.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCompressPathStarts());
        result = result * 59 + Arrays.deepHashCode(this.getFiles());
        result = result * 59 + Arrays.deepHashCode(this.getS3s());
        result = result * 59 + Arrays.deepHashCode(this.getHttps());
        return result;
    }

    public String toString() {
        return "FileManagerConfig(enable=" + this.getEnable() + ", defaultName=" + this.getDefaultName() + ", compressPathStarts=" + Arrays.deepToString(this.getCompressPathStarts()) + ", files=" + Arrays.deepToString(this.getFiles()) + ", s3s=" + Arrays.deepToString(this.getS3s()) + ", https=" + Arrays.deepToString(this.getHttps()) + ")";
    }
}

