/*
 * Decompiled with CFR 0.152.
 */
package framework.client;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class WebUserAgent {
    private String os = "unknown";
    private String browser = "unknown";
    private String userAgent = "";

    public WebUserAgent(String userAgent) {
        this.userAgent = userAgent;
        this.parse(userAgent);
    }

    public WebUserAgent(HttpServletRequest request) {
        String ua = request.getHeader("user-agent");
        if (StringUtils.isBlank((CharSequence)ua)) {
            ua = "unknown";
        }
        this.userAgent = ua;
        this.parse(ua);
    }

    private void parse(String userAgent) {
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            return;
        }
        String ua = userAgent.toLowerCase();
        String os = "unknown";
        String browser = "unknown";
        os = ua.contains("windows") ? "Windows" : (ua.contains("mac") ? "Mac" : (ua.contains("android") ? userAgent.substring(ua.indexOf("android")).split(";")[0] : (ua.indexOf("iphone") >= 0 ? "IPhone" : (ua.contains("linux") ? "Linux" : (ua.contains("x11") ? "Unix" : "unknown")))));
        if (ua.contains("edge")) {
            browser = userAgent.substring(ua.indexOf("edge")).split(" ")[0].replace("/", "-");
        } else if (ua.contains("ucbrowser")) {
            browser = ua.substring(ua.indexOf("ucbrowser")).split(" ")[0].replace("/", "-").replace("ucbrowser", "UC\u6d4f\u89c8\u5668");
        } else if (ua.contains("ubrowser")) {
            browser = ua.substring(ua.indexOf("ubrowser")).split(" ")[0].replace("/", "-").replace("ubrowser", "UC\u6d4f\u89c8\u5668");
        } else if (ua.contains("msie")) {
            String substring = userAgent.substring(ua.indexOf("msie")).split(";")[0];
            browser = substring.replace("MSIE", "IE").replace(" ", "-");
        } else if (ua.contains("safari") && ua.contains("version")) {
            browser = userAgent.substring(userAgent.indexOf("Safari")).split(" ")[0].split("/")[0] + "-" + userAgent.substring(userAgent.indexOf("Version")).split(" ")[0].split("/")[1];
        } else if (ua.contains("opr")) {
            browser = userAgent.substring(ua.indexOf("opr")).split(" ")[0].replace("/", "-").replace("OPR", "Opera");
        } else if (ua.contains("opera")) {
            browser = userAgent.substring(ua.indexOf("opera")).split(" ")[0].split("/")[0] + "-" + userAgent.substring(ua.indexOf("version")).split(" ")[0].split("/")[1];
        } else if (ua.contains("chrome")) {
            browser = userAgent.substring(userAgent.indexOf("Chrome")).split(" ")[0].replace("/", "-");
        } else if (ua.contains("firefox")) {
            browser = userAgent.substring(userAgent.indexOf("Firefox")).split(" ")[0].replace("/", "-");
        } else if (ua.contains("rv")) {
            String IEVersion = userAgent.substring(userAgent.indexOf("rv")).split(" ")[0].replace("rv:", "-");
            browser = "IE" + IEVersion.substring(0, IEVersion.length() - 1);
        } else {
            browser = "unknown";
        }
        this.os = os;
        this.browser = browser;
    }

    public String getOs() {
        return this.os;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getUserAgent() {
        return this.userAgent;
    }
}

