/*
 * Decompiled with CFR 0.152.
 */
package framework.captcha;

import framework.captcha.CaptchaBase;
import framework.captcha.CaptchaGenerator;
import framework.captcha.CaptchaInfo;
import framework.captcha.CaptchaServlet;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.util.StringUtils;

public class CaptchaSimple
extends CaptchaBase
implements CaptchaServlet {
    private static final Logger log = LoggerFactory.getLogger(CaptchaSimple.class);

    public CaptchaSimple(Cache cache) {
        super(cache);
    }

    public CaptchaSimple(Cache cache, CaptchaGenerator generator) {
        super(cache, generator);
    }

    @Override
    public void output(HttpServletRequest req, HttpServletResponse resp, String id) throws IOException {
        if (!StringUtils.hasLength((String)id)) {
            resp.setStatus(400);
            resp.getWriter().write("not set param id");
            return;
        }
        if (this.getCache() == null) {
            resp.setStatus(500);
            resp.getWriter().write("not set cache");
            log.warn("Verification: not set cache");
            return;
        }
        CaptchaInfo captchaInfo = this.newCaptcha(id);
        resp.setHeader("Pragma", "no-cache");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setDateHeader("Expires", 0L);
        resp.setContentType("image/jpeg");
        try (ServletOutputStream outputStream = resp.getOutputStream();){
            ImageIO.write((RenderedImage)captchaInfo.getImage(), "jpeg", (OutputStream)outputStream);
        }
    }
}

