/*
 * Decompiled with CFR 0.152.
 */
package framework.captcha;

import framework.captcha.CaptchaInfo;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.RandomStringUtils;

public class CaptchaGenerator {
    private int width = 150;
    private int height = 48;
    private int length = 4;
    private int fontWidth = 27;
    private int fontHeight = 42;
    private int codeYBase = 40;
    private boolean isNoise = true;
    private char[] codeSequence = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'W', 'X', 'Y', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public CaptchaGenerator() {
    }

    public CaptchaGenerator(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public CaptchaInfo generate() {
        String code = this.generateCode();
        BufferedImage image = this.generateImage(code);
        return new CaptchaInfo(code, image);
    }

    protected String generateCode() {
        String code = RandomStringUtils.random((int)this.length, (char[])this.codeSequence);
        return code;
    }

    protected String getFontName() {
        return "Sans-serif";
    }

    protected void generateNoise(Graphics gd) {
        Random random = new Random();
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int i = 0; i < 100; ++i) {
            red = random.nextInt(250);
            green = random.nextInt(250);
            blue = random.nextInt(250);
            gd.setColor(new Color(red, green, blue));
            int x = random.nextInt(this.width);
            int y = random.nextInt(this.height);
            gd.drawLine(x, y, x + 10, y + 10);
        }
    }

    protected BufferedImage generateImage(String code) {
        BufferedImage buffImg = new BufferedImage(this.width, this.height, 1);
        Graphics gd = buffImg.getGraphics();
        Random random = new Random();
        gd.setColor(Color.WHITE);
        gd.fillRect(0, 0, this.width, this.height);
        Font font = new Font(this.getFontName(), 0, this.fontHeight);
        gd.setFont(font);
        int red = 0;
        int green = 0;
        int blue = 0;
        char[] codes = code.toCharArray();
        int preWidth = this.fontWidth - (int)((float)this.fontWidth * 0.75f);
        for (int i = 0; i < codes.length; ++i) {
            red = random.nextInt(255);
            green = random.nextInt(255);
            blue = random.nextInt(255);
            gd.setColor(new Color(red, green, blue));
            gd.drawString(String.valueOf(codes[i]), (i + 1) * this.fontWidth - preWidth, this.codeYBase);
        }
        if (this.isNoise()) {
            this.generateNoise(gd);
        }
        return buffImg;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 10; ++i) {
            File file = new File("/tmp/simpleCode" + i + ".jpg");
            try (FileOutputStream out = new FileOutputStream(file);){
                CaptchaInfo captchaInfo = new CaptchaGenerator().generate();
                ImageIO.write((RenderedImage)captchaInfo.getImage(), "jpeg", out);
                System.out.println("SimpleCode: " + captchaInfo.getCode());
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getFontWidth() {
        return this.fontWidth;
    }

    public void setFontWidth(int fontWidth) {
        this.fontWidth = fontWidth;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public void setFontHeight(int fontHeight) {
        this.fontHeight = fontHeight;
    }

    public int getCodeYBase() {
        return this.codeYBase;
    }

    public void setCodeYBase(int codeYBase) {
        this.codeYBase = codeYBase;
    }

    public boolean isNoise() {
        return this.isNoise;
    }

    public void setNoise(boolean isNoise) {
        this.isNoise = isNoise;
    }

    public char[] getCodeSequence() {
        return this.codeSequence;
    }
}

