/*
 * Decompiled with CFR 0.152.
 */
package framework.captcha;

import framework.captcha.CaptchaBase;
import framework.captcha.CaptchaGenerator;
import framework.captcha.CaptchaInfo;
import framework.captcha.CaptchaServlet;
import framework.utils.JsonUtil;
import framework.vo.ResultInfo;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.util.StringUtils;

public class CaptchaBase64
extends CaptchaBase
implements CaptchaServlet {
    private static final Logger log = LoggerFactory.getLogger(CaptchaBase64.class);

    public CaptchaBase64(Cache cache) {
        super(cache);
    }

    public CaptchaBase64(Cache cache, CaptchaGenerator generator) {
        super(cache, generator);
    }

    @Override
    public void output(HttpServletRequest req, HttpServletResponse resp, String id) throws IOException {
        String base64;
        if (!StringUtils.hasLength((String)id)) {
            resp.setStatus(400);
            resp.getWriter().write("not set param id");
            return;
        }
        if (this.getCache() == null) {
            resp.setStatus(500);
            resp.getWriter().write("not set cache");
            log.warn("Verification: not set cache");
            return;
        }
        CaptchaInfo captchaInfo = this.newCaptcha(id);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)captchaInfo.getImage(), "jpeg", outputStream);
            base64 = Base64.getEncoder().encodeToString(outputStream.toByteArray());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("image_base", "data:image/png;base64," + base64);
        map.put("id", id);
        ResultInfo resultInfo = new ResultInfo(map);
        resp.setHeader("Pragma", "no-cache");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setDateHeader("Expires", 0L);
        resp.setContentType("application/json");
        String s = JsonUtil.toJsonString(resultInfo);
        resp.getWriter().write(s);
    }
}

