/*
 * Decompiled with CFR 0.152.
 */
package framework.captcha;

import framework.captcha.Captcha;
import framework.captcha.CaptchaGenerator;
import framework.captcha.CaptchaInfo;
import framework.exceptions.ConfigurationException;
import org.springframework.cache.Cache;
import org.springframework.util.StringUtils;

public class CaptchaBase
implements Captcha {
    private Cache cache;
    private CaptchaGenerator generator;
    private Boolean ignoreCase = true;

    public CaptchaBase(Cache cache) {
        this.generator = new CaptchaGenerator();
        this.cache = cache;
    }

    public CaptchaBase(Cache cache, CaptchaGenerator generator) {
        this.generator = generator;
        this.cache = cache;
    }

    @Override
    public CaptchaInfo newCaptcha(String id) {
        CaptchaInfo captchaInfo = this.getGenerator().generate();
        this.getCache().put((Object)this.buildKey(id), (Object)captchaInfo.getCode());
        return captchaInfo;
    }

    @Override
    public boolean check(String id, String code) {
        if (!StringUtils.hasLength((String)id)) {
            return false;
        }
        if (!StringUtils.hasText((String)code)) {
            return false;
        }
        if (this.getCache() == null) {
            throw new ConfigurationException("not set cache");
        }
        String s = (String)this.getCache().get((Object)this.buildKey(id), String.class);
        boolean r = this.getIgnoreCase() != false ? code.equalsIgnoreCase(s) : code.equals(s);
        return r;
    }

    @Override
    public void remove(String id) {
        if (this.getCache() != null) {
            this.getCache().evict((Object)this.buildKey(id));
        }
    }

    protected String buildKey(String id) {
        return "captcha:" + id;
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    @Override
    public CaptchaGenerator getGenerator() {
        return this.generator;
    }

    public void setIgnoreCase(Boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public Boolean getIgnoreCase() {
        return this.ignoreCase;
    }
}

