/*
 * Decompiled with CFR 0.152.
 */
package framework.base.provider;

import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.mapper.mapperhelper.MapperTemplate;
import tk.mybatis.mapper.mapperhelper.SqlHelper;

public class LoadPrimaryKeyProvider
extends MapperTemplate {
    public LoadPrimaryKeyProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public String loadPrimaryKey(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(LoadPrimaryKeyProvider.selectPKColumns(entityClass));
        sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
        sql.append(SqlHelper.whereAllIfColumns((Class)entityClass, (boolean)this.isNotEmpty()));
        return sql.toString();
    }

    public String loadPrimaryKeyByPK(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(LoadPrimaryKeyProvider.selectPKColumns(entityClass));
        sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
        sql.append(SqlHelper.wherePKColumns((Class)entityClass));
        return sql.toString();
    }

    private static String selectPKColumns(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(LoadPrimaryKeyProvider.getPKColumns(entityClass));
        sql.append(" ");
        return sql.toString();
    }

    private static String getPKColumns(Class<?> entityClass) {
        Set columnSet = EntityHelper.getPKColumns(entityClass);
        if (columnSet.size() == 1) {
            return ((EntityColumn)columnSet.iterator().next()).getColumn();
        }
        if (columnSet.isEmpty()) {
            throw new RuntimeException(entityClass.getCanonicalName() + " is not has primary key column");
        }
        StringBuilder sql = new StringBuilder();
        for (EntityColumn entityColumn : columnSet) {
            sql.append(entityColumn.getColumn()).append(",");
        }
        return sql.substring(0, sql.length() - 1);
    }
}

