/*
 * Decompiled with CFR 0.152.
 */
package framework.base;

import framework.base.BaseService;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class UpdateOrInsert<S extends BaseService<T, K>, T, K> {
    private final S service;

    public UpdateOrInsert(S service) {
        this.service = service;
    }

    public Integer updateByPK(T param) {
        if (this.getService().existsByPK(param)) {
            return this.getService().update(param);
        }
        return this.getService().add(param);
    }

    public Integer update(T param, Function<T, T> query) {
        return this.update(param, query, null);
    }

    public Integer update(T param, Function<T, T> query, BiConsumer<T, T> modify) {
        T where = query.apply(param);
        T oldObject = this.getService().loadPrimaryKeyFirst(where);
        if (oldObject != null) {
            if (modify != null) {
                modify.accept(param, oldObject);
            }
            return this.getService().update(param);
        }
        return this.getService().add(param);
    }

    public S getService() {
        return this.service;
    }
}

