/*
 * Decompiled with CFR 0.152.
 */
package framework.base;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Table;
import tk.mybatis.mapper.util.StringUtil;

public class UpdateObjectProvider {
    private static final ConcurrentHashMap<Class<?>, List<Field>> FIELD_CACHE = new ConcurrentHashMap();

    protected List<Field> loadField(Class<?> objClass) {
        return FIELD_CACHE.computeIfAbsent(objClass, clazz -> Arrays.stream(clazz.getDeclaredFields()).filter(f -> {
            try {
                String getterName = "get" + f.getName().substring(0, 1).toUpperCase() + f.getName().substring(1);
                Method getter = clazz.getMethod(getterName, new Class[0]);
                return Modifier.isPublic(getter.getModifiers());
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }).peek(f -> f.setAccessible(true)).collect(Collectors.toList()));
    }

    public String updateObject(Map map) {
        Object obj = map.get("obj");
        Object where = map.get("where");
        Table tableAnnotation = obj.getClass().getAnnotation(Table.class);
        if (tableAnnotation == null) {
            throw new IllegalArgumentException(obj.getClass().getName() + " not apply @Table");
        }
        String tableName = tableAnnotation.name();
        List<Field> fields = this.loadField(obj.getClass());
        StringBuilder sql = new StringBuilder("UPDATE " + tableName + " SET ");
        for (Field field : fields) {
            String fieldName = field.getName();
            if ("id".equals(fieldName)) continue;
            Column column = field.getAnnotation(Column.class);
            String dbFieldName = column != null ? column.name() : StringUtil.camelhumpToUnderline((String)fieldName);
            sql.append(dbFieldName).append("=#{obj.").append(fieldName).append("}, ");
        }
        sql.delete(sql.length() - 2, sql.length());
        fields = this.loadField(where.getClass());
        StringBuilder wsql = new StringBuilder();
        for (Field field : fields) {
            Object value;
            try {
                value = field.get(where);
            }
            catch (IllegalAccessException e) {
                value = null;
            }
            if (value == null) continue;
            String fieldName = field.getName();
            Column column = field.getAnnotation(Column.class);
            String dbFieldName = column != null ? column.name() : StringUtil.camelhumpToUnderline((String)fieldName);
            wsql.append(dbFieldName).append("=#{where.").append(fieldName).append("} AND ");
        }
        if (wsql.length() == 0) {
            throw new IllegalArgumentException("Not set query where condition");
        }
        sql.append(" WHERE ").append((CharSequence)wsql.delete(wsql.length() - 5, wsql.length()));
        return sql.toString();
    }

    public String updateObjectById(Map map) {
        Object obj = map.get("obj");
        Table tableAnnotation = obj.getClass().getAnnotation(Table.class);
        if (tableAnnotation == null) {
            throw new IllegalArgumentException(obj.getClass().getName() + " not apply @Table");
        }
        String tableName = tableAnnotation.name();
        List<Field> fields = this.loadField(obj.getClass());
        StringBuilder sql = new StringBuilder("UPDATE " + tableName + " SET ");
        StringBuilder wsql = new StringBuilder();
        for (Field field : fields) {
            String dbFieldName;
            String fieldName = field.getName();
            Column column = field.getAnnotation(Column.class);
            String string = dbFieldName = column != null ? column.name() : StringUtil.camelhumpToUnderline((String)fieldName);
            if ("id".equals(fieldName)) {
                wsql.append(dbFieldName).append("=#{obj.").append(fieldName).append("} AND ");
                continue;
            }
            sql.append(dbFieldName).append("=#{obj.").append(fieldName).append("}, ");
        }
        sql.delete(sql.length() - 2, sql.length());
        if (wsql.length() == 0) {
            throw new IllegalArgumentException("id field not found in " + obj.getClass().getName());
        }
        sql.append(" WHERE ").append((CharSequence)wsql.delete(wsql.length() - 5, wsql.length()));
        return sql.toString();
    }
}

