/*
 * Decompiled with CFR 0.152.
 */
package framework.base;

import framework.runtime.SystemContext;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import tk.mybatis.mapper.common.Mapper;

public class SqlExecutor {
    public static int BATCH_DEFAULT_SIZE = 1000;

    public static <T, M extends Mapper<T>> int batchAdd(List<T> dataList, Class<M> mapperClass) {
        return SqlExecutor.batchAdd(BATCH_DEFAULT_SIZE, dataList, mapperClass);
    }

    public static <T, M extends Mapper<T>> int batchAdd(int batchSize, List<T> dataList, Class<M> mapperClass) {
        return SqlExecutor.batchExecute(batchSize, dataList, mapperClass, (m, t) -> m.insertSelective(t));
    }

    public static <T, M extends Mapper<T>> int batchExecute(int batchSize, List<T> dataList, Class<M> mapperClass, BiConsumer<M, T> function) {
        int totalSize = dataList.size();
        int rows = 0;
        SqlSessionFactory factory = SystemContext.getBean(SqlSessionFactory.class);
        try (SqlSession session = null;){
            session = factory.openSession(ExecutorType.BATCH);
            Mapper mapper = (Mapper)session.getMapper(mapperClass);
            for (int i = 0; i < totalSize; i += batchSize) {
                int end = Math.min(totalSize, i + batchSize);
                List<T> list = dataList.subList(i, end);
                for (T obj : list) {
                    function.accept((M)mapper, (Mapper)obj);
                }
                session.commit();
                rows += list.size();
            }
        }
        return rows;
    }

    public static <T, M extends Mapper<T>> int batchUpdate(List<T> dataList, Class<M> mapperClass) {
        return SqlExecutor.batchUpdate(BATCH_DEFAULT_SIZE, dataList, mapperClass);
    }

    public static <T, M extends Mapper<T>> int batchUpdate(int batchSize, List<T> dataList, Class<M> mapperClass) {
        return SqlExecutor.batchExecute(batchSize, dataList, mapperClass, (m, t) -> m.updateByPrimaryKeySelective(t));
    }

    public static <T, M extends Mapper<T>> int batchDelete(List<T> dataList, Class<M> mapperClass) {
        return SqlExecutor.batchDelete(BATCH_DEFAULT_SIZE, dataList, mapperClass);
    }

    public static <T, M extends Mapper<T>> int batchDelete(int batchSize, List<T> dataList, Class<M> mapperClass) {
        return SqlExecutor.batchExecute(batchSize, dataList, mapperClass, (m, t) -> m.delete(t));
    }

    public static <T, M extends Mapper<T>> int batchDeletePK(List<T> dataList, Class<M> mapperClass) {
        return SqlExecutor.batchExecute(BATCH_DEFAULT_SIZE, dataList, mapperClass, (m, t) -> m.deleteByPrimaryKey(t));
    }

    public static <T, M extends Mapper<T>> int batchDeletePK(int batchSize, List<T> dataList, Class<M> mapperClass) {
        return SqlExecutor.batchExecute(batchSize, dataList, mapperClass, (m, t) -> m.deleteByPrimaryKey(t));
    }

    public static <T> int batchAdd(List<T> dataList, String sqlId) {
        return SqlExecutor.batchAdd(BATCH_DEFAULT_SIZE, dataList, sqlId);
    }

    public static <T> int batchAdd(int batchSize, List<T> dataList, String sqlId) {
        int totalSize = dataList.size();
        int rows = 0;
        SqlSessionFactory factory = SystemContext.getBean(SqlSessionFactory.class);
        try (SqlSession session = null;){
            session = factory.openSession(ExecutorType.BATCH);
            for (int i = 0; i < totalSize; i += batchSize) {
                int end = Math.min(totalSize, i + batchSize);
                List<T> list = dataList.subList(i, end);
                session.insert(sqlId, list);
                session.commit();
                rows += list.size();
            }
        }
        return rows;
    }

    public static <T> int batchUpdate(List<T> dataList, String sqlId) {
        return SqlExecutor.batchUpdate(BATCH_DEFAULT_SIZE, dataList, sqlId);
    }

    public static <T> int batchUpdate(int batchSize, List<T> dataList, String sqlId) {
        int totalSize = dataList.size();
        int rows = 0;
        SqlSessionFactory factory = SystemContext.getBean(SqlSessionFactory.class);
        try (SqlSession session = null;){
            session = factory.openSession(ExecutorType.BATCH);
            for (int i = 0; i < totalSize; i += batchSize) {
                int end = Math.min(totalSize, i + batchSize);
                List<T> list = dataList.subList(i, end);
                session.update(sqlId, list);
                session.commit();
                rows += list.size();
            }
        }
        return rows;
    }

    public static <T> int batchDelete(List<T> dataList, String sqlId) {
        return SqlExecutor.batchDelete(BATCH_DEFAULT_SIZE, dataList, sqlId);
    }

    public static <T> int batchDelete(int batchSize, List<T> dataList, String sqlId) {
        int totalSize = dataList.size();
        int rows = 0;
        SqlSessionFactory factory = SystemContext.getBean(SqlSessionFactory.class);
        try (SqlSession session = null;){
            session = factory.openSession(ExecutorType.BATCH);
            for (int i = 0; i < totalSize; i += batchSize) {
                int end = Math.min(totalSize, i + batchSize);
                List<T> list = dataList.subList(i, end);
                session.delete(sqlId, list);
                session.commit();
                rows += list.size();
            }
        }
        return rows;
    }
}

