/*
 * Decompiled with CFR 0.152.
 */
package framework.base;

import framework.base.SqlExecutor;
import java.util.List;
import java.util.function.BiConsumer;
import tk.mybatis.mapper.common.Mapper;

public interface BatchService<T, M extends Mapper<T>> {
    default public int getBatchSize() {
        return SqlExecutor.BATCH_DEFAULT_SIZE;
    }

    public Class<M> getMapperClass();

    default public int batchAdd(List<T> dataList) {
        return SqlExecutor.batchAdd(this.getBatchSize(), dataList, this.getMapperClass());
    }

    default public int batchUpdate(List<T> dataList) {
        return SqlExecutor.batchUpdate(this.getBatchSize(), dataList, this.getMapperClass());
    }

    default public int batchDelete(List<T> dataList) {
        return SqlExecutor.batchDelete(this.getBatchSize(), dataList, this.getMapperClass());
    }

    default public int batchDeletePK(List<T> dataList) {
        return SqlExecutor.batchDeletePK(this.getBatchSize(), dataList, this.getMapperClass());
    }

    default public int batchAdd(List<T> dataList, String sqlId) {
        return SqlExecutor.batchAdd(this.getBatchSize(), dataList, sqlId);
    }

    default public int batchUpdate(List<T> dataList, String sqlId) {
        return SqlExecutor.batchUpdate(this.getBatchSize(), dataList, sqlId);
    }

    default public int batchDelete(List<T> dataList, String sqlId) {
        return SqlExecutor.batchDelete(this.getBatchSize(), dataList, sqlId);
    }

    default public int batchExecute(List<T> dataList, BiConsumer<M, T> function) {
        return SqlExecutor.batchExecute(this.getBatchSize(), dataList, this.getMapperClass(), function);
    }
}

