/*
 * Decompiled with CFR 0.152.
 */
package framework.base;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import framework.base.BaseMapper;
import framework.proxy.MapProperty;
import java.util.List;
import java.util.function.Function;

public interface BaseService<T, K> {
    public BaseMapper<T, K> getMapper();

    default public PageInfo<T> list(T param, Integer pageIndex, Integer pageSize) {
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List<T> list = this.getMapper().list(param);
        return new PageInfo(list);
    }

    default public T first(T param) {
        PageHelper.startPage((int)1, (int)1, (boolean)false);
        T result = this.one(param);
        return result;
    }

    default public T one(T param) {
        T result = this.getMapper().one(param);
        return result;
    }

    default public Integer count(T param) {
        Integer result = this.getMapper().count(param);
        return result;
    }

    default public List<T> load(T param) {
        List<T> list = this.getMapper().load(param);
        return list;
    }

    default public PageInfo<T> load(T param, Integer pageIndex, Integer pageSize) {
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List<T> list = this.getMapper().load(param);
        return new PageInfo(list);
    }

    default public Integer add(T param) {
        Integer result = this.getMapper().add(param);
        return result;
    }

    default public Integer update(T param) {
        Integer result = this.getMapper().update(param);
        return result;
    }

    default public Integer delete(T param) {
        return this.getMapper().delete(param);
    }

    default public Integer delete(T param, Function<T, K> finder) {
        int result = 0;
        List list = this.getMapper().select(param);
        for (Object item : list) {
            K k = finder.apply(item);
            result += this.deleteById(k).intValue();
        }
        return result;
    }

    default public Integer deleteById(K id) {
        Integer result = this.getMapper().deleteById(id);
        return result;
    }

    default public Integer deleteByPK(T param) {
        Integer result = this.getMapper().deleteByPrimaryKey(param);
        return result;
    }

    default public T loadById(K id) {
        T result = this.getMapper().loadById(id);
        return result;
    }

    default public T loadByIdPK(T param) {
        Object result = this.getMapper().selectByPrimaryKey(param);
        return (T)result;
    }

    default public List<T> loadByIds(List<K> ids) {
        List<T> result = this.getMapper().loadByIds(ids);
        return result;
    }

    default public Integer deleteByIds(List<K> ids) {
        int rows = 0;
        if (ids == null) {
            return rows;
        }
        for (K id : ids) {
            rows += this.deleteById(id).intValue();
        }
        return rows;
    }

    default public int dynamicUpdateById(T obj) {
        if (!(obj instanceof MapProperty)) {
            throw new RuntimeException("parameter obj must use MapperUtil.dynamicEntity() created");
        }
        return this.getMapper().dynamicUpdateById(obj);
    }

    default public int dynamicUpdate(T obj, T where) {
        if (!(obj instanceof MapProperty)) {
            throw new RuntimeException("parameter obj must use MapperUtil.dynamicEntity() created");
        }
        if (!(where instanceof MapProperty)) {
            throw new RuntimeException("parameter obj must use MapperUtil.dynamicEntity() created");
        }
        return this.getMapper().dynamicUpdate(obj, where);
    }

    default public boolean exists(T param) {
        return this.loadPrimaryKeyFirst(param) != null;
    }

    default public boolean existsByPK(T param) {
        return this.getMapper().loadPrimaryKeyByPK(param) != null;
    }

    default public List<T> loadPrimaryKey(T param) {
        return this.getMapper().loadPrimaryKey(param);
    }

    default public T loadPrimaryKeyFirst(T param) {
        PageHelper.startPage((int)1, (int)1, (boolean)false);
        List list = this.getMapper().loadPrimaryKey(param);
        if (list != null && !list.isEmpty()) {
            return (T)list.get(0);
        }
        return null;
    }
}

