package framework.vo;

import com.github.pagehelper.PageInfo;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 统一列表类结果描述对象
 *
 * @param <T>
 */
@Data
public class ResultList<T> extends ResultInfo<Collection<T>> implements Serializable {
    private Long total = 0L;        //数据总数
    private Integer pageIndex = 1;         //当前页
    private Integer pageSize = 10;    //分页大小

    /**
     * 默认初始化
     */
    public ResultList() {
        this(new ArrayList<>());
    }

    /**
     * 失败输出数据
     *
     * @param failMessage
     */
    public ResultList(String failMessage) {
        super(null);
        super.failed(failMessage);
    }

    /**
     * 成功输出数据
     *
     * @param data
     */
    public ResultList(Collection<T> data) {
        super(data);
        this.pageIndex = 1;
        this.pageSize = data.size();
        this.total = data.size() + 0L;
    }

    /**
     * 成功输出数据
     *
     * @param data
     */
    public ResultList(Collection<T> data, long total, int pageIndex, int pageSize) {
        super(data);
        this.total = total;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public ResultList(int code, String msg) {
        super(code, msg);
    }

    public ResultList(int code, String msg, Collection<T> data) {
        super(code, msg, data);
        this.pageIndex = 1;
        this.pageSize = data.size();
        this.total = data.size() + 0L;
    }

    public ResultList(int code, String msg, Collection<T> data, Long total, Integer pageIndex, Integer pageSize) {
        super(code, msg, data);
        this.total = total;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public ResultList(int code, Collection<T> data, Long total, Integer pageIndex, Integer pageSize) {
        super(code, data);
        this.total = total;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public ResultList(PageInfo<T> info) {
        super(info.getList());
        this.total = info.getTotal();
        this.pageIndex = info.getPageNum();
        this.pageSize = info.getPageSize();
    }

    public List<T> dataAsList() {
        if (this.getData() instanceof List) {
            return (List<T>) this.getData();
        }
        return new ArrayList<>(this.getData());
    }
}
