package framework.vo;

import lombok.Data;

import java.io.Serializable;

/**
 * 统一结果描述对象
 *
 * @param <T>
 */
@Data
public class ResultInfo<T> implements Serializable {
    private int code = 0;                //状态码, 0 成功  1 失败
    private String msg = "";                //失败信息
    private T data;            //需要返回的结果

    public static final int SUCCESS = 0;
    public static final int FAILED = 1;

    public ResultInfo() {
        this.code = ResultInfo.SUCCESS;
    }

    /**
     * 成功输出数据
     *
     * @param data
     */
    public ResultInfo(T data) {
        this.code = ResultInfo.SUCCESS;
        this.data = data;
    }

    public ResultInfo(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public ResultInfo(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public ResultInfo(int code, T data) {
        this.code = code;
        this.data = data;
    }

    public ResultInfo failed(String message) {
        this.code = ResultInfo.FAILED;
        this.msg = message;
        return this;
    }

    public boolean checkSuccess() {
        return SUCCESS == this.code;
    }

    public boolean checkFailed() {
        return FAILED == this.code;
    }

}
