package framework.vo;

/**
 * 结构简易封装
 */
public class R {

    /**
     * 成功
     *
     * @param <T>
     * @return
     */
    public static <T> ResultInfo<T> ok() {
        return new ResultInfo<>();
    }

    /**
     * 成功
     *
     * @param data
     * @param <T>
     * @return
     */
    public static <T> ResultInfo<T> ok(T data) {
        return new ResultInfo<>(data);
    }

    /**
     * 成功
     *
     * @param data
     * @param msg
     * @param <T>
     * @return
     */
    public static <T> ResultInfo<T> ok(T data, String msg) {
        return new ResultInfo<>(ResultInfo.SUCCESS, msg, data);
    }

    /**
     * 失败
     *
     * @param msg
     * @param <T>
     * @return
     */
    public static <T> ResultInfo<T> failed(String msg) {
        return new ResultInfo<>(ResultInfo.FAILED, msg);
    }

    /**
     * 失败
     *
     * @param msg
     * @param data
     * @param <T>
     * @return
     */
    public static <T> ResultInfo<T> failed(String msg, T data) {
        return new ResultInfo<>(ResultInfo.FAILED, msg, data);
    }

    /**
     * 失败
     *
     * @param msg
     * @param code
     * @param <T>
     * @return
     */
    public static <T> ResultInfo<T> failed(int code, String msg) {
        return new ResultInfo<>(code, msg, null);
    }

    /**
     * 失败
     *
     * @param msg
     * @param code
     * @param data
     * @param <T>
     * @return
     */
    public static <T> ResultInfo<T> failed(int code, String msg, T data) {
        return new ResultInfo<>(code, msg, data);
    }

}
