package framework.vo;

import com.github.pagehelper.PageInfo;

import java.util.Collection;

/**
 * 列表结构简易封装
 */
public class L {

    /**
     * 成功
     *
     * @param <T>
     * @return
     */
    public static <T> ResultList<T> ok() {
        return new ResultList<>();
    }

    /**
     * 成功
     *
     * @param data
     * @param <T>
     * @return
     */
    public static <T> ResultList<T> ok(Collection<T> data) {
        return new ResultList<>(data);
    }

    /**
     * 成功
     *
     * @param data
     * @param msg
     * @param <T>
     * @return
     */
    public static <T> ResultList<T> ok(Collection<T> data, String msg) {
        return new ResultList<>(ResultInfo.SUCCESS, msg, data);
    }

    /**
     * 成功
     *
     * @param <T>
     * @return
     */
    public static <T> ResultList<T> ok(PageInfo<T> info) {
        return new ResultList<>(info);
    }

    /**
     * 成功
     *
     * @param msg
     * @param data
     * @param total
     * @param pageIndex
     * @param pageSize
     * @param <T>
     * @return
     */
    public static <T> ResultList<T> ok(String msg, Collection<T> data, Long total, Integer pageIndex, Integer pageSize) {
        return new ResultList<>(ResultInfo.SUCCESS, msg, data, total, pageIndex, pageSize);
    }

    /**
     * 成功
     *
     * @param data
     * @param total
     * @param pageIndex
     * @param pageSize
     * @param <T>
     * @return
     */
    public static <T> ResultList<T> ok(Collection<T> data, Long total, Integer pageIndex, Integer pageSize) {
        return new ResultList<>(ResultInfo.SUCCESS, data, total, pageIndex, pageSize);
    }

    /**
     * 失败
     *
     * @param msg
     * @param <T>
     * @return
     */
    public static <T> ResultList<T> failed(String msg) {
        return new ResultList<>(ResultInfo.FAILED, msg);
    }

    /**
     * 失败
     *
     * @param msg
     * @param data
     * @param <T>
     * @return
     */
    public static <T> ResultList<T> failed(String msg, Collection<T> data) {
        return new ResultList<>(ResultInfo.FAILED, msg, data);
    }

}
