package framework.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableUtil {

    private static Pattern camelPattern = Pattern.compile("[A-Z]");

    /**
     * 首字母大写,其它全小写
     *
     * @return: java.lang.String
     */
    public static String capitalizeFirstLetter(String str) {
        char firstChar = str.toUpperCase().charAt(0);
        String nextStr = str.toLowerCase().substring(1);
        return firstChar + nextStr;
    }

    /**
     * 首字母大写，其它不变
     *
     * @return: java.lang.String
     */
    public static String capitalizeFirstCharLetter(String str) {
        String firstChar = String.valueOf(str.charAt(0)).toUpperCase();
        String nextStr = str.substring(1);
        return firstChar + nextStr;
    }

    /**
     * 首字母小写，其它不变
     *
     * @return: java.lang.String
     */
    public static String lowercaseFirstCharLetter(String str) {
        String firstChar = String.valueOf(str.charAt(0)).toLowerCase();
        String nextStr = str.substring(1);
        return firstChar + nextStr;
    }

    /**
     * 将下划线中划线转为驼峰
     *
     * @param str
     * @return java.lang.String
     */
    public static String underlineToCamel(String str) {
        String[] items = str.split("_|\\-|\\.");
        StringBuilder builder = new StringBuilder();
        String firstStr = "";
        String tempStr = "";
        for (int i = 0; i < items.length; i++) {
            //第一个数组全部小写
            if (i == 0) {
                firstStr = items[0].toLowerCase();
                builder.append(firstStr);
            } else {
                //以后的数组首字母大写
                tempStr = capitalizeFirstLetter(items[i]);
                builder.append(tempStr);
            }
        }
        return builder.toString();
    }

    /**
     * 驼峰转下划线，小写
     *
     * @param humpStr
     * @return java.lang.String
     */
    public static String camelToUnderline(String humpStr) {
        boolean fullUpperCase = false;
        boolean wordFirstUpperCase = false;
        return camelToUnderline(humpStr, fullUpperCase, wordFirstUpperCase);
    }

    /**
     * 驼峰转下划线
     *
     * @param humpStr
     * @param fullUpperCase      全文大写
     * @param wordFirstUpperCase 单词首字母大写
     * @return java.lang.String
     */
    public static String camelToUnderline(String humpStr, boolean fullUpperCase, boolean wordFirstUpperCase) {
        Matcher matcher = camelPattern.matcher(humpStr);
        StringBuffer builder = new StringBuffer();
        while (matcher.find()) {
            if (wordFirstUpperCase)
                matcher.appendReplacement(builder, "_" + capitalizeFirstLetter(matcher.group(0).toLowerCase()));
            else
                matcher.appendReplacement(builder, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(builder);

        //转为大写
        if (fullUpperCase) {
            return builder.toString().toUpperCase();
        }
        if (wordFirstUpperCase) {
            return capitalizeFirstCharLetter(builder.toString());
        }
        return builder.toString();
    }
}
