package framework.utils;

import java.nio.ByteBuffer;
import java.util.UUID;

public class UUIDUtil {

    /**
     * UUID to bytes
     */
    public static byte[] toBytes() {
        return toBytes(UUID.randomUUID());
    }

    /**
     * UUID to bytes
     */
    public static byte[] toBytes(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    /**
     * UUID to bytes
     */
    public static UUID fromBytes(byte[] bytes) {
        if (bytes.length != 16) {
            throw new IllegalArgumentException("UUID byte array length must be 16");
        }
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        long mostSigBits = bb.getLong();
        long leastSigBits = bb.getLong();
        return new UUID(mostSigBits, leastSigBits);
    }

}
