package framework.utils;

import java.util.function.Supplier;

public class StringUtil {

    /**
     * 对象转换为字符串
     *
     * @param obj
     * @return
     */
    public static String objectToString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    /**
     * 对象转换为字符串，对象未设置时返回默认值
     *
     * @param obj
     * @param def
     * @return
     */
    public static String objectToString(Object obj, String def) {
        return obj == null ? def : obj.toString();
    }

    /**
     * 对象转换为字符串，对象未设置时返回默认值
     *
     * @param obj
     * @param defaultCreator
     * @return
     */
    public static String objectToString(Object obj, Supplier<String> defaultCreator) {
        return obj == null ? defaultCreator.get() : obj.toString();
    }

    /**
     * 首写字母大写
     *
     * @param str
     * @return
     */
    public static String firstUpper(String str) {
        if (str == null) return null;
        if (str.length() == 1) return str.toUpperCase();

        String s1 = str.substring(0, 1).toUpperCase();
        String s2 = str.substring(1);

        return s1 + s2;
    }

    /**
     * 首写字母小写
     *
     * @param str
     * @return
     */
    public static String firstLower(String str) {
        if (str == null) return null;
        if (str.length() == 1) return str.toLowerCase();

        String s1 = str.substring(0, 1).toLowerCase();
        String s2 = str.substring(1);

        return s1 + s2;
    }

    /**
     * 截取指定长度字符
     *
     * @param str
     * @param len
     * @return
     */
    public static String left(String str, int len) {
        return left(str, len, "");
    }

    /**
     * 截取指定长度字符
     *
     * @param str
     * @param len
     * @param append
     * @return
     */
    public static String left(String str, int len, String append) {
        if (str == null) {
            return null;
        } else if (len < 1) {
            return "";
        } else {
            return str.length() <= len ? str : str.substring(0, len) + append;
        }
    }

    /**
     * 若为空则设置默认值
     *
     * @param str
     * @param _default
     * @return
     */
    public static String nullDefault(String str, String _default) {
        if (str == null)
            return _default;
        return str;
    }

}
