package framework.utils;

import lombok.SneakyThrows;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

/**
 * 客户端工具类
 */
public class ServletUtil {
    /**
     * 获取String参数
     */
    public static String getParameter(String name) {
        return getRequest().getParameter(name);
    }

    /**
     * 获取String参数
     */
    public static String getParameter(String name, String defaultValue) {
        String s = StringUtil.objectToString(getRequest().getParameter(name), defaultValue);
        return s;
    }

    /**
     * 获取Integer参数
     */
    @SneakyThrows
    public static Integer getInteger(String name) {
        HttpServletRequest request = getRequest();
        //int v = ConvertUtil.toInteger(getRequest().getParameter(name));
        Integer parameter = ServletRequestUtils.getIntParameter(request, name);
        return parameter;
    }

    /**
     * 获取Integer参数
     */
    public static Integer getInteger(String name, Integer defaultValue) {
        HttpServletRequest request = getRequest();
        int v = ServletRequestUtils.getIntParameter(request, name, defaultValue);
        return v;
    }

    @SneakyThrows
    public static Long getLong(String name) {
        HttpServletRequest request = getRequest();
        Long parameter = ServletRequestUtils.getLongParameter(request, name);
        return parameter;
    }

    public static Long getLong(String name, Long defaultValue) {
        HttpServletRequest request = getRequest();
        Long parameter = ServletRequestUtils.getLongParameter(request, name, defaultValue);
        return parameter;
    }

    /**
     * 获取Boolean参数
     */
    public static Boolean getBoolean(String name) {
        String p = getParameter(name);
        boolean b = ConvertUtil.toBoolean(p);
        return b;
    }

    /**
     * 获取Boolean参数
     */
    public static Boolean getBoolean(String name, Boolean defaultValue) {
        String p = getParameter(name);
        if (!StringUtils.hasText(p)) return defaultValue;
        boolean b = ConvertUtil.toBoolean(p);
        return b;
    }

    /**
     * 获取request
     */
    public static HttpServletRequest getRequest() {
        return getRequestAttributes().getRequest();
    }

    /**
     * 获取response
     */
    public static HttpServletResponse getResponse() {
        return getRequestAttributes().getResponse();
    }

    /**
     * 获取session
     */
    public static HttpSession getSession() {
        return getRequest().getSession();
    }

    public static ServletRequestAttributes getRequestAttributes() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        return (ServletRequestAttributes) attributes;
    }

    /**
     * 将字符串写到客户端
     *
     * @param response 渲染对象
     * @param string   待渲染的字符串
     * @return null
     */
    public static String WriteJsonString(HttpServletResponse response, String string) {
        try {
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            response.getWriter().print(string);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * URL编码
     *
     * @param str 内容
     * @return 编码后的内容
     */
    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    /**
     * URL解码
     *
     * @param str 内容
     * @return 解码后的内容
     */
    public static String urlDecode(String str) {
        try {
            return URLDecoder.decode(str, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            return null;
        }
    }

}
