package framework.utils;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

/**
 * 对象工具
 */
public class ObjectUtil {

    /**
     * @param obj 需要判断的对象
     * @Description: 判断对象是否为空 为空返回true，否则返回 false
     * @Return boolean
     * @Throws
     */
    @SuppressWarnings("rawtypes")
    public static boolean isNullOrEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence) obj).length() == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection) obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map) obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            return length == 0;
        }

//        if (obj instanceof Object[]) {
//            Object[] object = (Object[]) obj;
//            if (object.length == 0) {
//                return true;
//            }
//            boolean empty = true;
//            for (int i = 0; i < object.length; i++) {
//                if (!isNullOrEmpty(object[i])) {
//                    empty = false;
//                    break;
//                }
//            }
//            return empty;
//        }

        return false;
    }

}
