package framework.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class MailUtil {

    private static final String EMAIL_PATTERN =
            "^(([a-zA-Z0-9][a-zA-Z0-9\\_\\-]*[a-zA-Z0-9])|[a-zA-Z0-9])+(?:\\.[a-zA-Z0-9\\_\\-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,}$";

    public static Pattern pattern = Pattern.compile(EMAIL_PATTERN);


    /**
     * 验证Email
     *
     * @param email 格式：name@mail.com，name@mail.com.cn
     * @return 验证成功返回true，验证失败返回false
     */
    public static boolean isEmail(String email) {
        return pattern.matcher(email).matches();
    }


    public static void main(String[] args) {
        List<String> list = new ArrayList<>();
        list.add("1@cctv.com");
        list.add("1@cctv.com.cn");
        list.add("1@1.cn");
        list.add("1.1@cctv.com.cn");
        list.add("1-1@cctv.cn");
        list.add("1-1@cn");
        list.add("-a@cctv.com.cn");
        list.add(".000a@cctv.com.cn");
        list.add("000a.@cctv.com.cn");
        list.add("a-@cctv.com.cn");
        list.add("abc.com@com.cn");
        list.add("abc.com@cctv.com.cn");

        for (int i = 0; i < list.size(); i++) {
            System.out.println(list.get(i) + ": " + isEmail(list.get(i)));
        }
    }
}
