package framework.utils;

import org.apache.commons.codec.binary.Base64;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;

public class ImageUtil {

    /**
     * 将网络图片编码为base64
     *
     * @param url
     * @return
     * @throws Exception
     */
    public static String encodeImageToBase64(URL url) throws IOException {
        //将图片文件转化为字节数组字符串，并对其进行Base64编码处理
        //System.out.println("图片的路径为:" + url.toString());
        //打开链接
        HttpURLConnection conn = null;
        conn = (HttpURLConnection) url.openConnection();
        //设置请求方式为"GET"
        conn.setRequestMethod("GET");
        //超时响应时间为5秒
        conn.setConnectTimeout(5 * 1000);
        //
        byte[] data = null;
        //通过输入流获取图片数据
        try (InputStream inStream = conn.getInputStream()) {
            //得到图片的二进制数据，以二进制封装得到数据，具有通用性
            try (ByteArrayOutputStream outStream = new ByteArrayOutputStream()) {
                //创建一个Buffer字符串
                byte[] buffer = new byte[8192];
                //每次读取的字符串长度，如果为-1，代表全部读取完毕
                int len = 0;
                //使用一个输入流从buffer里把数据读取出来
                while ((len = inStream.read(buffer)) != -1) {
                    //用输出流往buffer里写入数据，中间参数代表从哪个位置开始读，len代表读取的长度
                    outStream.write(buffer, 0, len);
                }
                //关闭输入流
                data = outStream.toByteArray();
            }
        }

        return Base64.encodeBase64String(data);
    }

    /**
     * 对字节数组字符串进行Base64解码并生成图片
     *
     * @param imgStr      图片数据
     * @param imgFilePath 保存图片全路径地址
     * @return
     */
    public static boolean generateImage(String imgStr, String imgFilePath) {
        // 图像数据为空
        if (imgStr == null) {
            return false;
        }

        //BASE64Decoder decoder = new BASE64Decoder();
        //byte[] b = decoder.decodeBuffer(imgStr);

        try {
            // Base64解码
            byte[] b = Base64.decodeBase64(imgStr);
            for (int i = 0; i < b.length; ++i) {
                // 调整异常数据
                if (b[i] < 0) {
                    b[i] += 256;
                }
            }
            // 生成jpg图片
            try (OutputStream out = new FileOutputStream(imgFilePath)) {
                out.write(b);
                out.flush();
            }
            return true;
        } catch (Exception e) {
            return false;
        }
    }


    /**
     * 将图片转换成Base64编码
     *
     * @param in 待处理图片数据流
     * @return
     */
    public static String imageToBase64(InputStream in) {
        //将图片文件转化为字节数组字符串，并对其进行Base64编码处理
        byte[] data = null;
        try {
            //读取图片字节数组
            data = new byte[in.available()];
            in.read(data);
        } catch (IOException exception) {
            data = new byte[0];
            exception.printStackTrace();
        }
        //
        return new String(Base64.encodeBase64(data));
    }
}
