package framework.utils;

import framework.snowflake.Snowflake;

public class IdUtil {

    public static IdGenerator generator = new IdGenerator() {
        @Override
        public Long newId() {
            long id = Snowflake.nextId();
            return id;
        }
    };

    public static Long newId() {
        long id = generator.newId();
        return id;
    }

    /**
     * ID生成器
     */
    public interface IdGenerator {
        Long newId();
    }

}
