package framework.utils;

import org.apache.commons.lang3.StringUtils;

/**
 * Base64 编码
 */
public class Base64Util {

    /**
     * 从URL安全的Base64串还原Base64串
     *
     * @param safeBase64
     * @return
     */
    public static String fromUrlSafeBase64(String safeBase64) {
        safeBase64 = safeBase64.replace('.', '+')
                .replace('-', '/');
        int padding = safeBase64.length() * 3 % 4;
        if (padding != 0) {
            safeBase64 = StringUtils.rightPad(safeBase64, padding, '=');
        }
        return safeBase64;
    }

    /**
     * 转换为URL安全的Base64串
     *
     * @param base64
     * @return
     */
    public static String toUrlSafeBase64(String base64) {
        return base64.replace('+', '.')
                .replace('/', '-')
                .replace("=", "");
    }


}
