package framework.utils;


import framework.units.BaseCoder;

import java.util.UUID;

public class Base58Util {
    /**
     * 标准Base58字符集（去除了0/O/I/l等易混淆字符）
     */
    public static final String CHARS = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    private static final BaseCoder CODER = new BaseCoder(CHARS);

    public static String encode(long number) {
        return CODER.encode(number);
    }

    public static String newId() {
        return CODER.encode(IdUtil.newId());
    }

    public static long decode(String encoded) {
        return CODER.decode(encoded);
    }

    public static String encodeBytes(byte[] input) {
        return CODER.bytesEncode(input);
    }

    public static byte[] decodeBytes(String encoded) {
        return CODER.bytesDecode(encoded);
    }

    public static void main(String[] args) {
        long timestamp = System.currentTimeMillis() / 1000;
        System.out.println("原始时间戳: " + timestamp);

        String encoded = encode(timestamp);
        System.out.println("Base32编码: " + encoded);

        long decoded = decode(encoded);
        System.out.println("解码结果: " + decoded);

        long id = IdUtil.newId();
        String eid = CODER.encode(id);
        System.out.println("ID: " + id);
        System.out.println("编码: " + eid);
        System.out.println("解码: " + decode(eid));

        // 测试bytes转换
        UUID uuid = UUID.randomUUID();
        System.out.println("ID: " + uuid);
        byte[] bytes = UUIDUtil.toBytes(uuid);
        String encodedBytes = encodeBytes(bytes);
        System.out.println("符号: " + uuid.toString().replace("-", ""));
        System.out.println("编码: " + encodedBytes);
        byte[] decodedBytes = decodeBytes(encodedBytes);
        UUID decodedUuid = UUIDUtil.fromBytes(decodedBytes);
        System.out.println("解码: " + decodedUuid);
    }
}

