package framework.utils;


import framework.units.BaseCoder;

public class Base32Util {
    /**
     * Base32字符集：2-9 + 小写字母, 去除了0/1/l/o，共32个字符
     */
    public static final String CHARS = "23456789abcdefghijkmnpqrstuvwxyz";
    private static final BaseCoder CODER = new BaseCoder(CHARS);

    public static String newId() {
        return CODER.encode(IdUtil.newId());
    }

    public static String encode(long number) {
        return CODER.encode(number);
    }

    public static long decode(String encoded) {
        return CODER.decode(encoded);
    }

    public static void main(String[] args) {
        long timestamp = System.currentTimeMillis() / 1000;
        System.out.println("原始时间戳: " + timestamp);

        String encoded = encode(timestamp);
        System.out.println("Base32编码: " + encoded);

        long decoded = decode(encoded);
        System.out.println("解码结果: " + decoded);

        long id = IdUtil.newId();
        String eid = CODER.encode(id);
        System.out.println("ID: " + id);
        System.out.println("编码: " + eid);
        System.out.println("解码: " + decode(eid));

    }
}

