package framework.storage;

import java.io.IOException;
import java.io.InputStream;

/**
 * 未启用的 NONE
 */
public class FileStorageNone implements FileStorage {

    @Override
    public boolean enable() {
        return false;
    }

    @Override
    public long save(InputStream inputStream, String filePath, boolean compression) throws IOException {
        throw new NoEnableFileStorageException("Not enable file storage, you can config sys.file.storage-type");
    }

    @Override
    public InputStream getStream(String filePath, boolean compression) throws IOException {
        throw new NoEnableFileStorageException("Not enable file storage, you can config sys.file.storage-type");
    }

    @Override
    public void delete(String filePath, boolean compression) throws IOException {
        throw new NoEnableFileStorageException("Not enable file storage, you can config sys.file.storage-type");
    }

    @Override
    public long length(String filePath, boolean compression) throws IOException {
        throw new NoEnableFileStorageException("Not enable file storage, you can config sys.file.storage-type");
    }
}
