package framework.storage;

import java.util.Set;

public interface FileManager extends FileStorage, Iterable {

    /**
     * 实例数
     *
     * @return
     */
    int size();

    /**
     * 获取已配置实例名
     *
     * @return
     */
    Set<String> names();

    /**
     * 获取一个组的存储实例
     *
     * @param name
     * @return
     */
    FileStorage findByName(String name);

    /**
     * 依据路径查找存储器
     *
     * @param path
     * @return
     */
    FileStorage findByPath(String path);

}
