package framework.service;

/**
 * 标志管理器
 */
public interface FlagAdmin {

    /**
     * 设置默认标记
     */
    void setFlag();

    /**
     * 设置指定名称为默认标记
     *
     * @param name
     */
    void setFlag(String name);

    /**
     * 设置标记
     *
     * @param name
     * @param value
     */
    void setFlag(String name, String value);

    /**
     * 删除标记
     */
    void remove();

    /**
     * 删除标记
     *
     * @param name
     */
    void remove(String name);

    /**
     * 是否有默认标记
     *
     * @return
     */
    boolean hasFlag();

    /**
     * 默认名称是否为指定标记
     *
     * @param value
     * @return
     */
    boolean hasFlag(String value);

    /**
     * 是否为指定的标记
     *
     * @param name
     * @param value
     * @return
     */
    boolean hasFlag(String name, String value);

}
