package framework.security.token;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.Random;

/**
 * 授权Token 主体
 */
@Data
@NoArgsConstructor
public class AuthTokenInfo {
    /**
     * 用户标识
     */
    private long id;
    /**
     * 过期时间
     */
    private Date expireTime;
    /**
     * 持续时长
     */
    private int duration;
    /**
     * 序列号或会话号(非唯一)
     */
    private long sid;


    public AuthTokenInfo(long id, int duration) {
        this.id = id;
        this.duration = duration;
        this.expireTime = new Date(System.currentTimeMillis() + duration * 1000L);
        this.sid = Math.abs(new Random().nextLong()) % 9007199254740991L;
    }


    public AuthTokenInfo(long id, Date expireTime, int duration, long sid) {
        this.id = id;
        this.expireTime = expireTime;
        this.duration = duration;
        this.sid = sid;
    }

    /**
     * 是否已过期
     *
     * @return
     */
    public boolean isExpired() {
        if (this.expireTime == null)
            return false;
        boolean expired = new Date().getTime() > this.expireTime.getTime();
        return expired;
    }
}
