package framework.security.password;

import java.util.Collection;

/**
 * 密码服务
 */
public interface PasswordService {

    /**
     * 密码模式集合
     *
     * @return
     */
    Collection<PasswordMode> modes();

    /**
     * 密码编码
     *
     * @param password
     * @param salt
     * @return
     */
    String encode(String password, String salt);

    /**
     * 密码编码
     *
     * @param password
     * @param salt
     * @param mode
     * @return
     */
    String encode(String mode, String password, String salt);

    /**
     * 校验密码是否匹配
     *
     * @param password
     * @param encodePassword
     * @return
     */
    boolean matched(String password, String salt, String encodePassword);

    /**
     * 依据模式返回密码编码器
     *
     * @param name
     * @return
     */
    PasswordMode getMode(String name);

    /**
     * 添加密码模式
     *
     * @param mode
     */
    void addMode(PasswordMode mode);

    /**
     * 删除密码模式
     *
     * @param name
     */
    void delMode(String name);

}
