package framework.security.password;

/**
 * 密码编码器
 */
public interface PasswordMode {

    /**
     * 模式名称
     *
     * @return
     */
    String getName();

    /**
     * 编码
     *
     * @param rawPassword
     * @param salt
     * @return
     */
    String encode(String rawPassword, String salt);

    /**
     * 匹配校验性
     *
     * @param salt
     * @param rawPassword
     * @param encodedPassword
     * @return
     */
    boolean matched(String rawPassword, String salt, String encodedPassword);

}
