package framework.security.password;

import org.apache.commons.codec.digest.DigestUtils;

/**
 * MD5加密模式
 */
public class PasswordMD5Mode implements PasswordMode {
    @Override
    public String getName() {
        return "MD5";
    }

    @Override
    public String encode(String rawPassword, String salt) {
        String s1 = DigestUtils.md5Hex(rawPassword + salt);
        String s2 = DigestUtils.md5Hex(salt + rawPassword);
        return s1 + s2;
    }

    @Override
    public boolean matched(String rawPassword, String salt, String encodedPassword) {
        String p1 = encode(rawPassword, salt);
        String p2 = encodedPassword;
        return p1.equals(p2);
    }

}
