package framework.security;

/**
 * 授权服务
 */
public interface AuthService {

    /**
     * 当前授权人员是否为超管
     *
     * @return
     */
    boolean isSupperAdmin();

    /**
     * 获取授权的账户ID
     *
     * @return
     */
    long getAccountId();

    /**
     * 是否已授权
     *
     * @return
     */
    boolean isAuthenticated();

    /**
     * 获取授权密钥/Token/Password等
     *
     * @return
     */
    String getSecret();

    /**
     * 获取当前会话标识
     * @return
     */
    long getSid();

}
