package framework.security;

import framework.exceptions.BusinessException;
import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;

/**
 * 授权异常
 */
public class AuthException extends BusinessException {
    /**
     * 一般性错误
     */
    public static final int FAILED = 0;
    /**
     * 提交的资料不全
     */
    public static final int REQUEST_INVALID = 1;
    /**
     * 登录限制
     */
    public static final int LOGIN_LIMITED = 2;
    /**
     * 账户不存在
     */
    public static final int ACCOUNT_NOT_EXISTS = 100;
    public static final int ACCOUNT_DISABLED = 101;
    public static final int ACCOUNT_EXPIRED = 102;
    /**
     * 账号未设置密码
     */
    public static final int PASSWORD_NO_SET = 200;
    public static final int PASSWORD_EXPIRED = 201;
    public static final int PASSWORD_NO_MATCH = 202;
    public static final int PASSWORD_NO_INPUT = 203;
    public static final int PASSWORD_INVALID = 204;
    /**
     * 批准：拒绝
     */
    public static final int APPROVAL_REJECTED = 300;
    /**
     * 批准：等待
     */
    public static final int APPROVAL_PENDING = 301;

    /**
     * 验证码
     */
    public static final int CAPTCHA_ERROR = 400;

    /**
     * 认证结果对照表
     */
    @Getter
    private static final Map<Integer, String> resultMap = new HashMap<>();

    /**
     * 不记录日志的认证结果表
     */
    @Getter
    private static final Map<Integer, String> noLogResultMap = new HashMap<>();

    static {
        resultMap.put(FAILED, "FAILED");
        resultMap.put(REQUEST_INVALID, "REQUEST_INVALID");
        //
        resultMap.put(LOGIN_LIMITED, "LOGIN_LIMITED");
        //
        resultMap.put(ACCOUNT_NOT_EXISTS, "ACCOUNT_NOT_EXISTS");
        resultMap.put(ACCOUNT_DISABLED, "ACCOUNT_DISABLED");
        resultMap.put(ACCOUNT_EXPIRED, "ACCOUNT_EXPIRED");
        //
        resultMap.put(PASSWORD_NO_SET, "PASSWORD_NO_SET");
        resultMap.put(PASSWORD_EXPIRED, "PASSWORD_EXPIRED");
        resultMap.put(PASSWORD_NO_MATCH, "PASSWORD_NO_MATCH");
        resultMap.put(PASSWORD_NO_INPUT, "PASSWORD_NO_INPUT");
        resultMap.put(PASSWORD_INVALID, "PASSWORD_INVALID");
        //
        resultMap.put(APPROVAL_REJECTED, "APPROVAL_REJECTED");
        resultMap.put(APPROVAL_PENDING, "APPROVAL_PENDING");
        //
        resultMap.put(CAPTCHA_ERROR, "CAPTCHA_ERROR");

        //
        noLogResultMap.put(ACCOUNT_DISABLED, "ACCOUNT_DISABLED");
        noLogResultMap.put(ACCOUNT_EXPIRED, "ACCOUNT_EXPIRED");
    }

    public static boolean compare(AuthException authException, int autoResult) {
        return authException.getAuthResult() == autoResult;
    }

    /**
     * is auth result
     *
     * @param value
     * @return
     */
    public static boolean isExceptionValue(int value) {
        return resultMap.containsKey(value);
    }

    @Getter
    @Setter
    private int authResult;

    public AuthException(int authResult, String msg) {
        super(msg);
        this.authResult = authResult;
    }

    /**
     * 是否不记录该异常记录
     *
     * @return
     */
    public boolean isNoLog() {
        return noLogResultMap.containsKey(this.getAuthResult());
    }

    @Override
    public int getCode() {
        return super.getCode();
    }
}
