package framework.security;

import framework.exceptions.NotFoundException;

import java.util.List;

/**
 * 用户加载器
 */
public interface AccountLoader {

    /**
     * 依据用户名获取用户
     *
     * @param username
     * @return
     * @throws NotFoundException
     */
    Account loadUserByUsername(String username);

    /**
     * 依据用户ID获取用户
     *
     * @param id
     * @return
     * @throws NotFoundException
     */
    Account loadUserById(Long id);

    /**
     * 依据账户ID获取用户权限列表
     *
     * @param id
     * @return
     * @throws NotFoundException
     */
    List<String> loadPermissions(Long id);

    /**
     * 加载功能权限列表
     *
     * @return
     */
    List<FunctionPermission> loadFunctionPermission();

    /**
     * 加载所有的权限列表
     *
     * @return
     */
    List<String> loadAllPermission();

    /**
     * 因登录失败次数超限已被限制登录的时间秒数
     *
     * @param username
     * @return 限制的秒数
     */
    int loginFailLimit(String username);

    /**
     * 登入完成
     *
     * @param username
     */
    void loginSuccessful(String username, Long id);

    /**
     * 登入失败
     *
     * @param username
     * @param cause
     */
    void loginUnsuccessful(String username, String cause);

    /**
     * 登出完成
     *
     * @param id
     */
    void logoutSuccessful(Long id);

}
