package framework.security;

import java.security.Principal;
import java.util.Date;

/**
 * 账号对象
 */
public interface Account extends Principal {

    /**
     * 账号ID
     *
     * @return
     */
    long getId();

    /**
     * 密码
     *
     * @return
     */
    String getUsername();

    /**
     * 密码
     *
     * @return
     */
    String getPassword();

    /**
     * 密码盐
     *
     * @return
     */
    String getPasswordSalt();

    /**
     * 账号过期时间
     *
     * @return
     */
    Date accountExpired();

    /**
     * 密码过期时间
     *
     * @return
     */
    Date passwordExpired();

    /**
     * 是否需要需要修改密码
     *
     * @return
     */
    boolean passwordMustChanged();

    /**
     * 是否启用
     *
     * @return
     */
    boolean isEnabled();

    /**
     * 注册批准状态
     *
     * @return
     */
    RegApproval getRegApproval();

    /**
     * 状态检查
     */
    void statusCheck() throws RuntimeException;

}
