package framework.order;

import java.util.List;

/**
 * 排序工具
 */
public class OrderNumUtil {


    /**
     * 排序
     *
     * @param list
     * @param <T>
     */
    public static <T extends OrderNumOption> void order(List<T> list, boolean desc) {
        if (desc)
            desc(list);
        else
            asc(list);
    }

    /**
     * 升序
     *
     * @param list
     * @param <T>
     */
    public static <T extends OrderNumOption> void asc(List<T> list) {
        list.sort((a, b) -> {
            Long a1 = a.order() == null ? 0 : a.order();
            Long b1 = b.order() == null ? 0 : b.order();
            return a1.compareTo(b1);
        });
    }

    /**
     * 降序
     *
     * @param list
     * @param <T>
     */
    public static <T extends OrderNumOption> void desc(List<T> list) {
        list.sort((a, b) -> {
            Long a1 = a.order() == null ? 0 : a.order();
            Long b1 = b.order() == null ? 0 : b.order();
            return b1.compareTo(a1);
        });
    }

}
