package framework.exceptions;

import org.springframework.http.HttpStatus;

/**
 * 通用Web异常
 */
public class WebException extends RuntimeException {

    private int _errorCode = 500;

    public int errorCode() {
        return _errorCode;
    }

    public WebException() {
        super();
    }

    public WebException(String message) {
        super(message);
    }

    public WebException(int errorCode, String message) {
        super(message);
        this._errorCode = errorCode;

        HttpStatus status = HttpStatus.resolve(errorCode);
        if (status == null) {
            throw new IllegalArgumentException("Invalid error code: " + errorCode + ", must be a HTTP status code");
        }
    }

    public WebException(String message, Throwable cause) {
        super(message, cause);
    }

    public WebException(int errorCode, Throwable cause) {
        super(cause.getMessage(), cause);
        this._errorCode = errorCode;

        HttpStatus status = HttpStatus.resolve(errorCode);
        if (status == null) {
            throw new IllegalArgumentException("Invalid error code: " + errorCode + ", must be a HTTP status code");
        }
    }

}
