package framework.exceptions;

import framework.vo.ResultInfo;
import lombok.Getter;
import lombok.Setter;

/**
 * 通用一般性业务错误
 */
public class BusinessException extends RuntimeException {

    private int _code = 1;

    public int getCode() {
        return _code;
    }

    @Getter
    @Setter
    private Object data;

    public ResultInfo<Object> getResult() {
        ResultInfo<Object> info = new ResultInfo<>();
        info.setCode(this.getCode());
        info.setMsg(this.getMessage());
        info.setData(this.getData());
        return info;
    }

    public BusinessException() {
        super();
    }

    public BusinessException(String message) {
        super(message);
    }

    public BusinessException(int code, String message) {
        super(message);
        this._code = code;
    }

    public BusinessException(Object data, String message) {
        super(message);
        this.setData(data);
    }

    public BusinessException(String message, Throwable cause) {
        super(message, cause);
    }

    public BusinessException(Object data, String message, Throwable cause) {
        super(message, cause);
        this.setData(data);
    }

    public BusinessException(int code, String message, Throwable cause) {
        super(message, cause);
        this._code = code;
    }

    public BusinessException(int code, Throwable cause) {
        super(cause.getMessage(), cause);
        this._code = code;
    }

    public BusinessException(Throwable cause) {
        super(cause);
    }

}
