package framework.datatype;

import lombok.Getter;

import java.util.Map;

/**
 * 数据获取转换
 */
public class MapGetter extends DataConvertBase {

    @Getter
    private final Map map;

    /**
     * 初始化
     *
     * @param map
     */
    public MapGetter(Map map) {
        this.map = map;
    }

    /**
     * 数据获取
     *
     * @param name
     * @return
     */
    @Override
    public Object loadDataValue(String name) {
        return this.getMap().get(name);
    }

}
