package framework.datatype;

/**
 * 数据转换基础
 */
public abstract class DataConvertBase {

    /**
     * 获取数据
     *
     * @param name
     * @return
     */
    public abstract Object loadDataValue(String name);

    /**
     * 获取String值并以逗号分隔为数组
     *
     * @param name
     * @return
     */
    public String[] getAsArray(String name) {
        return getAsArray(name, null, ",");
    }

    /**
     * 获取String值并以逗号分隔为数组
     *
     * @param name
     * @param defaultValue
     * @return
     */
    public String[] getAsArray(String name, String defaultValue) {
        return getAsArray(name, defaultValue, ",");
    }

    /**
     * 获取String值并以指定符号分隔为数组
     *
     * @param name
     * @param defaultValue
     * @return
     */
    public String[] getAsArray(String name, String defaultValue, String separator) {
        String v = getAsString(name, defaultValue);
        if (v == null) return null;
        return v.split(separator);
    }

    /**
     * 获取String值
     *
     * @param name
     * @return
     */
    public String getAsString(String name) {
        return this.getAsString(name, null);
    }

    /**
     * 获取String值
     *
     * @param name
     * @param defaultValue
     * @return
     */
    public String getAsString(String name, String defaultValue) {
        Object v = this.loadDataValue(name);
        if (v == null)
            return defaultValue;
        if (v instanceof String)
            return (String) v;
        return v.toString();
    }

    /**
     * 获取Byte值
     *
     * @param name
     * @return
     */
    public Byte getAsByte(String name) {
        return this.getAsByte(name, null);
    }

    /**
     * 获取Byte值
     *
     * @param name
     * @param defaultValue
     * @return
     */
    public Byte getAsByte(String name, Byte defaultValue) {
        Object v = this.loadDataValue(name);
        if (v == null)
            return defaultValue;
        if (v instanceof Byte)
            return (Byte) v;
        return Byte.parseByte(v.toString());
    }

    /**
     * 获取Short值
     *
     * @param name
     * @return
     */
    public Short getAsShort(String name) {
        return getAsShort(name, null);
    }

    /**
     * 获取Short值
     *
     * @param name
     * @param defaultValue
     * @return
     */
    public Short getAsShort(String name, Short defaultValue) {
        Object v = this.loadDataValue(name);
        if (v == null)
            return defaultValue;
        if (v instanceof Short)
            return (Short) v;
        return Short.parseShort(v.toString());
    }

    /**
     * 获取Int值
     *
     * @param name
     * @return
     */
    public Integer getAsInt(String name) {
        return getAsInt(name, null);
    }

    /**
     * 获取Int值
     *
     * @param name
     * @param defaultValue
     * @return
     */
    public Integer getAsInt(String name, Integer defaultValue) {
        Object v = this.loadDataValue(name);
        if (v == null)
            return defaultValue;
        if (v instanceof Integer)
            return (Integer) v;
        return Integer.parseInt(v.toString());
    }

    /**
     * 获取Long值
     *
     * @param name
     * @return
     */
    public Long getAsLong(String name) {
        return getAsLong(name, null);
    }

    /**
     * 获取Long值
     *
     * @param name
     * @param defaultValue
     * @return
     */
    public Long getAsLong(String name, Long defaultValue) {
        Object v = this.loadDataValue(name);
        if (v == null)
            return defaultValue;
        if (v instanceof Long)
            return (Long) v;
        return Long.parseLong(v.toString());
    }


    /**
     * 获取Double值
     *
     * @param name
     * @return
     */
    public Double getAsDouble(String name) {
        return this.getAsDouble(name, null);
    }

    /**
     * 获取Double值
     *
     * @param name
     * @param defaultValue
     * @return
     */
    public Double getAsDouble(String name, Double defaultValue) {
        Object v = this.loadDataValue(name);
        if (v == null)
            return defaultValue;
        if (v instanceof Double)
            return (Double) v;
        return Double.parseDouble(v.toString());
    }

    /**
     * 获取Float值
     *
     * @param name
     * @return
     */
    public Float getAsFloat(String name) {
        return this.getAsFloat(name, null);
    }

    /**
     * 获取Float值
     *
     * @param name
     * @param defaultValue
     * @return
     */
    public Float getAsFloat(String name, Float defaultValue) {
        Object v = this.loadDataValue(name);
        if (v == null)
            return defaultValue;
        if (v instanceof Float)
            return (Float) v;
        return Float.parseFloat(v.toString());
    }

    /**
     * 获取Boolean值
     *
     * @param name
     * @return
     */
    public Boolean getAsBoolean(String name) {
        return this.getAsBoolean(name, null);
    }

    /**
     * 获取Boolean值
     *
     * @param name
     * @param defaultValue
     * @return
     */
    public Boolean getAsBoolean(String name, Boolean defaultValue) {
        Object v = this.loadDataValue(name);
        if (v == null)
            return defaultValue;
        if (v instanceof Boolean)
            return (Boolean) v;
        String s = v.toString();
        if (s.equals("1"))
            return true;
        if (s.equals("yes"))
            return true;
        return Boolean.parseBoolean(s);
    }

}
