package framework.crypto;

import lombok.extern.slf4j.Slf4j;

/**
 * 一般性加密算法实现
 */
@Slf4j
public class GeneralCryptoDisabled implements GeneralCrypto {

    @Override
    public boolean enable() {
        return false;
    }

    @Override
    public byte[] encrypt(byte[] data) {
        throw new UnsupportedOperationException("Not enable general crypto");
    }

    @Override
    public byte[] decrypt(byte[] data) {
        throw new UnsupportedOperationException("Not enable general crypto");
    }

    @Override
    public String getPublicKeyContent() {
        throw new UnsupportedOperationException("Not enable general crypto");
    }
}
