package framework.crypto;

import framework.config.GeneralCryptoConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

/**
 * 一般性加密算法
 */
@Slf4j
@Configuration
public class GeneralCryptoConfiguration {

    @Bean
    public GeneralCrypto generalCrypto(GeneralCryptoConfig generalCryptoConfig) {
        if (StringUtils.hasText(generalCryptoConfig.getPrivateKeyPath())) {
            GeneralCryptoImpl crypto = new GeneralCryptoImpl(generalCryptoConfig);
            if (crypto.enable()) {
                log.info("GeneralCrypto enabled");
            }
            return crypto;
        }
        return new GeneralCryptoDisabled();
    }

}
