package framework.crypto;

import javax.crypto.Cipher;

/**
 * 禁用的AES算法实例
 */
public class AESCryptoDisabled implements AESCrypto {
    @Override
    public boolean enable() {
        return false;
    }

    @Override
    public String getSecretKey() {
        throw new UnsupportedOperationException("Not enable aes crypto");
    }

    @Override
    public Cipher getEncodeCipher() {
        throw new UnsupportedOperationException("Not enable aes crypto");
    }

    @Override
    public Cipher getDecodeCipher(byte[] encryptedData) {
        throw new UnsupportedOperationException("Not enable aes crypto");
    }
}
