package framework.crypto;

import framework.config.AESCryptoConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

/**
 * AES加密算法配置
 */
@Slf4j
@Configuration
public class AESCryptoConfiguration {

    @Bean
    public AESCrypto aesCrypto(AESCryptoConfig config) {
        if (StringUtils.hasText(config.getSecretKey())) {
            AESCrypto crypto = config.getSecretIndex() != null && config.getSecretIndex() > -1
                    ? new AESCryptoPlus(config) : new AESCryptoImpl(config);
            if (crypto.enable()) {
                log.info("AESCrypto enabled");
            }
            return crypto;
        }
        return new AESCryptoDisabled();
    }

}
