package framework.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * 用户配置
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "sys.user")
public class UserConfig {

    /**
     * 获取配置的超级管理员ID
     * 配置后不管是否授权该账号均具有所有权限
     * 通常一个稳定运行的系统，经过调试期后，应将此ID设置为NULL。
     */
    private Long superAdminId = 1L;
    /**
     * 是否允许修改超管密码
     */
    private Integer superAdminPasswordChange = 0;
    /**
     * 管理员角色ID
     */
    private Integer adminRoleId = 1;
    /**
     * 登录失败计数过期时间
     */
    private Integer loginFailCounterExpireSeconds = 5 * 60;
    /**
     * 登录失败在计数有效期内允许的最大失败次数
     */
    private Integer loginFailMaxLimit = 5;
    /**
     * 用户密码默认的有效期时间（天）
     */
    private Integer passwordDefaultExpireDay = 90;
    /**
     * 新用户默认的角色ID
     */
    private Integer defaultRoleId = 0;

    /**
     * 判定是否为超管
     *
     * @param userId
     * @return
     */
    public boolean checkIsSuperAdminId(Long userId) {
        if (userId == null) return false;
        if (this.getSuperAdminId() == null) return false;
        return userId.equals(this.getSuperAdminId());
    }
}
