package framework.config;

import framework.runtime.SystemContext;
import framework.utils.PathUtil;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Data
@Configuration
@ConfigurationProperties(prefix = "server.servlet")
public class ServletConfig {

    /**
     * 应用路径
     */
    private String contextPath;

    private static ServletConfig _instance = null;

    private static ServletConfig instance() {
        if (_instance == null) {
            _instance = SystemContext.getBean(ServletConfig.class);
        }
        return _instance;
    }

    /**
     * 获取应用程序地址路径
     *
     * @param path
     * @return
     */
    public static String getAppPath(String path) {

        String s1 = PathUtil.removeFirstSlash(path);
        String s2 = PathUtil.removeEndSlash(instance().contextPath) + "/" + s1;
        return s2;
    }

}
